﻿using System;
using System.Collections.Generic;
using System.Text;
using System.Runtime.Serialization;

namespace BMS.FaultContracts
{
    /// <summary>
    /// Fault contract used for the configuration service exceptions.
    /// </summary>
    [DataContract]
    public class DefaultConfigException
    {
        /// <summary>
        /// Gets or sets the user name for which the configuration is defined.
        /// </summary>
        /// <value>
        /// The user name.
        /// </value>
        [DataMember]
        public string UserName { get; set; }

        /// <summary>
        /// Gets or sets the configuration exception message.
        /// </summary>
        /// <value>
        /// The message.
        /// </value>
        [DataMember]
        public string Message { get; set; }

        /// <summary>
        /// Override ToString().
        /// </summary>
        /// <returns>Friendly print of the exception.</returns>
        public override string ToString()
        {
            return Message + (String.IsNullOrEmpty(UserName) ? String.Empty : "  UserName = " + UserName);
        }
    }
}
